// serconf.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//

#include "stdafx.h"


#define C_BAUD 			0
#define C_PARITY		1
#define C_DATA			2
#define C_STOP			3
#define C_HANDSHAKE		4
#define C_WTIMEOUT 		5
#define C_RTIMEOUT 		6

char *commands[] = {	"BAUD",
						"PARITY",
						"DATA",
						"STOP",
						"HANDSHAKE",
						"WTIMEOUT",
						"RTIMEOUT",
						NULL};

char port[101];
HANDLE Port = INVALID_HANDLE_VALUE;
enum {success, error};

DCB dcb;
COMMTIMEOUTS timeo;

#define RETRIES	5


int _tmain(int argc, _TCHAR* argv[])
{
	printf("SERCONF version 0.5\n");

	if (argc < 2)
	{
		printf (	"Usage: serconf <port> [opts/commands]\n\n"
					"Where opts/commands are:\n"
					"  Baud=<value>\t\tbaud rate (110 to 256000, default=keep current)\n"
					"  Parity=<type>\t\t'none' (default), 'even', 'odd', 'mark' or 'space'\n"
					"  Data=<value>\t\t7 or 8 (default) bits\n"
					"  Stop=<value>\t\t1 (default) or 2 stop bits\n"
					"  Handshake=<type>\t'none' (default), 'dtr', 'rtc' or 'cts', 'both'\n"
					"  WTimeout=<value>\tmilliseconds (default=1000, 0=no timeout)\n"
					"  RTimeout=<value>\tmilliseconds (default=1000, 0=don't wait at all)\n"
				);

		return error;
	}

	strcpy (port, argv[1]);

	if (CommPortOpen (port) == error)
	{
		printf("Error: Unable to open com port '%s'\n", port);
		CommPortClose ();
		return error;
	}

	if (!GetCommState (Port, &dcb)) 
	{
		printf("Error: can't read state of com port '%s'\n", port);
		CommPortClose ();
		return error;  
	}

	if (!GetCommTimeouts (Port, &timeo)) 
	{
		printf("Error: can't read timeouts of com port '%s'\n", port);
		CommPortClose ();
		return error;  
	}

	dcb.fParity = TRUE; // enable parity checking - does not imply anything else
	dcb.fBinary = TRUE;
	dcb.fAbortOnError = FALSE;
	dcb.fParity = FALSE;
	dcb.fDsrSensitivity = FALSE;
	dcb.fTXContinueOnXoff = TRUE;
	dcb.fOutX = FALSE;
	dcb.fInX = FALSE;
	dcb.fDtrControl = DTR_CONTROL_ENABLE; 
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	dcb.fOutxCtsFlow = FALSE;
	dcb.fOutxDsrFlow = FALSE;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;

	timeo.ReadIntervalTimeout = 1000;
	timeo.ReadTotalTimeoutMultiplier = 0;
	timeo.ReadTotalTimeoutConstant = 500;
	timeo.WriteTotalTimeoutMultiplier = 1;
	timeo.WriteTotalTimeoutConstant = 1000;

	if (Dispatch (argc, argv) == error)
	{
		printf("Command dispatch failed -> Program Failed!\n");
		CommPortClose ();
		return error;
	}

	if (!SetCommState (Port, &dcb)) 
	{
		printf("Error: can't write state of com port '%s'\n", port);
		CommPortClose ();
		return error;  
	}

	if (!SetCommTimeouts (Port, &timeo)) 
	{
		printf("Error: can't set timeouts of com port '%s'\n", port);
		CommPortClose ();
		return error;  
	}

	CommPortClose ();
	return success;
}

BOOL Dispatch (unsigned int argc, char *argv[])
{
	unsigned int n, i;
	char *found;
	char cmd[101] = "";
	char arg[101] = "";

	for (n = 2; n < argc; n++)
	{
		strupr(argv[n]);
		arg[0] = '\0';
		found = strchr(argv[n], '=');
		if (!found) found = strchr(argv[n], '\0');
		else strncpy(arg, found + 1, 100);
		cmd[found - argv[n]] = '\0';
		strncpy(cmd, argv[n], found - argv[n]);

		for (i = 0; commands[i]; i++)
		{
			if (!strncmp(cmd, commands[i], strlen(cmd))) break;
		}

		if (commands[i] != NULL)
		{
			switch (i)
			{
				case C_BAUD:		dcb.BaudRate = atoi(arg);
									break;
				case C_PARITY:		switch(arg[0])
									{
									case 'n':
									case 'N':
										dcb.Parity = NOPARITY;
										break;
									case 'e':
									case 'E':
										dcb.Parity = EVENPARITY; //NOPARITY,EVENPARITY,ODDPARITY,SPACEPARITY,MARKPARITY
										break;
									case 'o':
									case 'O':
										dcb.Parity = ODDPARITY;
										break;
									case 's':
									case 'S':
										dcb.Parity = SPACEPARITY;
										break;
									case 'm':
									case 'M':
										dcb.Parity = MARKPARITY;
										break;
									}
									break;
				case C_DATA:		dcb.ByteSize = atoi(arg);
									break;
				case C_STOP:		switch(arg[0])
									{
									case '1':
										dcb.StopBits = ONESTOPBIT; // ONESTOPBIT / ONE5STOPBITS / TWOSTOPBITS
										break;
									case '2':
										dcb.StopBits = TWOSTOPBITS; 
										break;
									}
									break;
				case C_HANDSHAKE:	switch(arg[0])
									{
									case 'n': //NONE
									case 'N':
										dcb.fDtrControl = DTR_CONTROL_DISABLE;   //DTR_CONTROL_ENABLE / DTR_CONTROL_DISABLE
										dcb.fRtsControl = RTS_CONTROL_DISABLE;   //RTS_CONTROL_ENABLE / RTS_CONTROL_DISABLE	
										dcb.fOutxCtsFlow = FALSE;
										dcb.fOutxDsrFlow = FALSE;
										break;
									case 'd': //DTR only
									case 'D':
										dcb.fDtrControl = DTR_CONTROL_ENABLE;   //DTR_CONTROL_ENABLE / DTR_CONTROL_DISABLE
										dcb.fRtsControl = RTS_CONTROL_DISABLE;   //RTS_CONTROL_ENABLE / RTS_CONTROL_DISABLE
										dcb.fOutxCtsFlow = FALSE;
										dcb.fOutxDsrFlow = TRUE;
										break;
									case 'r': //RTS/CTS only
									case 'R':
									case 'c': //RTS/CTS only
									case 'C':
										dcb.fDtrControl = DTR_CONTROL_DISABLE;   //DTR_CONTROL_ENABLE / DTR_CONTROL_DISABLE
										dcb.fRtsControl = RTS_CONTROL_ENABLE;   //RTS_CONTROL_ENABLE / RTS_CONTROL_DISABLE
										dcb.fOutxCtsFlow = TRUE;
										dcb.fOutxDsrFlow = FALSE;
										break;
									case 'b': //BOTH
									case 'B':
										dcb.fDtrControl = DTR_CONTROL_ENABLE;   //DTR_CONTROL_ENABLE / DTR_CONTROL_DISABLE
										dcb.fRtsControl = RTS_CONTROL_ENABLE;   //RTS_CONTROL_ENABLE / RTS_CONTROL_DISABLE
										dcb.fOutxCtsFlow = TRUE;
										dcb.fOutxDsrFlow = TRUE;
										break;
									}
									break;
				case C_WTIMEOUT:	if (atoi(arg) == 0)
									{
										timeo.WriteTotalTimeoutMultiplier = 0;
										timeo.WriteTotalTimeoutConstant = 0;
									}
									else
									{
										timeo.WriteTotalTimeoutMultiplier = 1;
										timeo.WriteTotalTimeoutConstant = atoi(arg);
									}
									break;
				case C_RTIMEOUT:	if (atoi(arg) == 0)
									{
										timeo.ReadIntervalTimeout = MAXDWORD;
										timeo.ReadTotalTimeoutMultiplier = 0;
										timeo.ReadTotalTimeoutConstant = 0;
									}
									else
									{
										timeo.ReadIntervalTimeout = atoi(arg) * 2;
										timeo.ReadTotalTimeoutMultiplier = 0;
										timeo.ReadTotalTimeoutConstant = atoi(arg);
									}
									break;
			}
		}
		else
		{
			printf("unrecognized command \"%s\" at position %u!\n", cmd, n);
			return error;
		}
	}

	return success;
}

////////////////////////////////////////////////////////////////////////////////
unsigned int CommPortOpen (
	const char *port					// Name of the port
)
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  Description:  Opens the Port with standard communication settings         //
//                (9600bps, ...) and exclusive (not shared).                  //
//                                                                            //
//  Returnvalue:   0 if success                                               //
//                !0 if error                                                 //
//                                                                            //
//  Sideefects:   The global variable Port will be asigned the handle of the  //
//                port.                                                       //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
{
	if (Port != INVALID_HANDLE_VALUE) {
		return error;
	}

	// Open Port exclusive and shared
	Port = CreateFile (port, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_ALWAYS,
					   FILE_ATTRIBUTE_NORMAL, NULL);
	if (Port == INVALID_HANDLE_VALUE) {
		return error;
	}

	return success;
}

////////////////////////////////////////////////////////////////////////////////
unsigned int CommPortClose (void)
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  Description:  Closes the Port previusly opened with CommPortOpen ().      //
//                                                                            //
//  Returnvalue:   0 if success                                               //
//                !0 if error                                                 //
//                                                                            //
//  Sideefects:   The global variable Port will be set to                     //
//                INVALID_HANDLE_VALUE to indicate the closed state.          //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
{
	if (Port != INVALID_HANDLE_VALUE) 
	{
		if (CloseHandle (Port))	
		{
			Port = INVALID_HANDLE_VALUE;
		}
		else return error;
	}

	return success;
}

////////////////////////////////////////////////////////////////////////////////
unsigned int CommPortInit (void)
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  Description:  Initializes the Port with standard communication settings   //
//                (9600bps, ...).                                             //
//                                                                            //
//  Returnvalue:   0 if success                                               //
//                !0 if error                                                 //
//                                                                            //
//  Sideefects:                                                               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
{

	if (!GetCommState (Port, &dcb)) return error;  // Set CommState ...
	dcb.fParity = FALSE;
	dcb.fOutxCtsFlow = FALSE;
	dcb.fOutxDsrFlow = FALSE;
	dcb.fDsrSensitivity = FALSE;
	dcb.fTXContinueOnXoff = TRUE;
	dcb.fOutX = FALSE;
	dcb.fInX = FALSE;
	dcb.EvtChar = '$';
	if (!SetCommState (Port, &dcb)) return error;

	if (!GetCommTimeouts (Port, &timeo)) return error;  // Set CommTimeouts  ...
	timeo.ReadIntervalTimeout = 1000;
	timeo.ReadTotalTimeoutMultiplier = 1;
	timeo.ReadTotalTimeoutConstant = 500;
	timeo.WriteTotalTimeoutMultiplier = 1;
	timeo.WriteTotalTimeoutConstant = 1000;
	if (!SetCommTimeouts (Port, &timeo)) return error;
	if (!SetCommMask (Port, EV_RXCHAR|EV_RXFLAG)) return error;  // Set Comm event Mask

	return success;
}

////////////////////////////////////////////////////////////////////////////////
char * GetLastErrorMsg(void)
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  Description:  Logs a message into the file <logfile>                   	  //
//                                                                            //
//  Returnvalue:   0 if success                                               //
//                !0 if error                                                 //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
{
	static char msg[1024];
	long n;

	FormatMessage(
		FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		msg,
		1023,
		NULL
	);

	for (n = 0; msg[n]; n++) if ((msg[n] == '\n') || (msg[n] == '\r')) msg[n] = ' ';

	return msg;
}
